<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    include "../include/util.php";
    include "../include/costanti.php";
    include "../classi/GeneratoreUrl.php";
    include "../gUtil/DbManager.php";
    
    session_start();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb   = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom  = $geecomDb->leggiSingolaRiga("geec_prodotti", 3) ;
    
    switch ($operazione) {
        case 'approvaElementiSelezionati':
            $id                = filter_input(INPUT_POST, "id");
            $email             = filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES);
            $elementiApprovati = filter_input(INPUT_POST,"elementiApprovati",FILTER_SANITIZE_ADD_SLASHES);
            
            $datiApprovazione  = $geecomDb->leggiSingolaRiga("geec_approvazioniFile",$id);
            
            // l'utetne ha può inserire un'approvazione se la sua email è abilitata ad approvare e se non ha già inviato un'approvazione
            $query = "SELECT * FROM `geec_fileApprovatiUtente` WHERE occorenzaComponente='$id' AND emailUtente LIKE '$email'";
            $risApprovazioni = $geecomDb->eseguiQueryLettura($query);
            
            if($risApprovazioni->num_rows>0) {
                echo "Hai già effettuato l'approvazione";
            }
            else if(strpos($datiApprovazione["destinatari"],$email)===0 || strpos($datiApprovazione["destinatari"],$email)>0) {
                $query = "INSERT INTO `geec_fileApprovatiUtente` (`id`, `occorenzaComponente`, `emailUtente`, `elementiApprovati`) 
                            VALUES (NULL, '$id', '$email', '$elementiApprovati');";
                $geecomDb->eseguiQueryScrittura($query);
                echo "ok";
            }
            else  {
                echo "Questa email non è autorizzata ad inviare approvazioni";
            }
            
            break;
    }